/*
 * Decompiled with CFR 0.152.
 */
package ifs.docman.lotusnotes;

import com.ibm.rcp.ui.browser.BrowserFactory;
import com.ibm.rcp.ui.browser.EmbeddedBrowser;
import ifs.docman.lotusnotes.LotusNotesActionHandler;
import ifs.docman.lotusnotes.model.RegistryObjectModel;
import ifs.docman.lotusnotes.persistance.UserSettingsManager;
import ifs.docman.lotusnotes.ui.AboutDialog;
import ifs.docman.lotusnotes.ui.Error;
import ifs.docman.lotusnotes.ui.SettingsDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class MenuListener
implements Listener {
    public static final int ABOUT = 1;
    public static final int HELP = 2;
    public static final int SETTING = 3;
    public static final int SAVE_AS_NEW = 4;
    public static final int SEND_AND_SAVE = 5;
    private int menuId;
    private SettingsDialog settingsDialog;
    private static int counter;

    public MenuListener(int menuId) {
        this.menuId = menuId;
    }

    public void handleEvent(Event arg0) {
        switch (this.menuId) {
            case 1: {
                Shell shellAboutDialog = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                AboutDialog aboutDialog = new AboutDialog(shellAboutDialog);
                aboutDialog.open();
                break;
            }
            case 2: {
                this.browserwindow();
                break;
            }
            case 3: {
                Shell shellSettingsDialog = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                SettingsDialog settingsDialog = new SettingsDialog(shellSettingsDialog);
                Error.setActiveShell(shellSettingsDialog);
                settingsDialog.open();
                break;
            }
            case 4: {
                LotusNotesActionHandler.saveDocument();
                break;
            }
            case 5: {
                LotusNotesActionHandler.sendAndSaveDocument();
                break;
            }
        }
    }

    private void showHelp() {
        Display display = Display.getDefault();
        final Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new FillLayout());
        Browser browser = new Browser((Composite)shell, 0);
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                shell.setText(event.title);
            }
        });
        browser.setBounds(0, 0, 600, 400);
        shell.pack();
        shell.open();
        browser.setUrl(MenuListener.getDocumentationUrl());
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static String getDocumentationUrl() {
        try {
            RegistryObjectModel rObjectModel = UserSettingsManager.loadFromRegistry();
            return String.valueOf(rObjectModel.DocumentationBaseUrl) + "/" + rObjectModel.Language + "/CreateAndMaintainDocument/AboutLotusNotesPlugin.htm?StandAlone=true";
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return "";
    }

    private void browserwindow() {
        String id = "ifs.docman.lotusnotes.browserview";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("ID", id);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        EmbeddedBrowser browser = BrowserFactory.launch((IWorkbenchPage)activePage, configMap, (String)id);
        browser.setUrl(MenuListener.getDocumentationUrl());
    }
}

