/*
 * Decompiled with CFR 0.152.
 */
package ifs.docman.lotusnotes.localization;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TranslationLocator {
    private static File supportedLanguageFile;
    private static File defaultLanguageFile;
    private static File defaultTranslationFile;
    public static String DEFAULT_TRANSLATION_FILENAME;

    static {
        DEFAULT_TRANSLATION_FILENAME = "DocmanLotusNotesWidget";
    }

    public static void init() {
        File location = TranslationLocator.getLocalizationPath();
        if (!location.exists()) {
            location.mkdirs();
        }
        TranslationLocator.copySupportedFiles();
    }

    private static File copyFile(String fileName) {
        InputStream inStream = TranslationLocator.class.getResourceAsStream("/localization/" + fileName);
        File newFile = new File(TranslationLocator.getLocalizationPath(), fileName);
        if (!newFile.exists()) {
            try {
                newFile.createNewFile();
                FileOutputStream os = new FileOutputStream(newFile.getAbsoluteFile());
                byte[] biteArray = new byte[1024];
                int byteRead = 0;
                while ((byteRead = inStream.read(biteArray)) != -1) {
                    ((OutputStream)os).write(biteArray, 0, byteRead);
                }
                ((OutputStream)os).close();
                inStream.close();
            }
            catch (IOException iOException) {
                newFile.deleteOnExit();
                return null;
            }
        }
        return newFile;
    }

    private static void copySupportedFiles() {
        supportedLanguageFile = TranslationLocator.copyFile("SupportedLanguages.xml");
    }

    private static File getBase() {
        String appData = System.getenv("APPDATA");
        return new File(appData, String.format("%1$s%2$s%1$s%3$s%1$s%4$s", Character.valueOf(File.separatorChar), "IFS", "Document Management", "Lotus Notes"));
    }

    public static File getDefaultLanguageFile() {
        return defaultLanguageFile;
    }

    public static File getLocalizationPath() {
        File locPath = new File(TranslationLocator.getBase(), "Localization");
        System.out.println("locPath=" + locPath.getAbsolutePath());
        return locPath;
    }

    public static File getSupportedLanguageFile() {
        return supportedLanguageFile;
    }

    public static File getTranslationFile(String languageKey) {
        String currentTranslationFileName = String.valueOf(DEFAULT_TRANSLATION_FILENAME) + languageKey + ".xml";
        File f = new File(TranslationLocator.getLocalizationPath(), currentTranslationFileName);
        if (f.exists() || !TranslationLocator.translationFileExistInPack(currentTranslationFileName)) {
            return f;
        }
        return TranslationLocator.copyFile(currentTranslationFileName);
    }

    private static boolean translationFileExistInPack(String fileName) {
        InputStream inStream = TranslationLocator.class.getResourceAsStream("/localization/" + fileName);
        try {
            if (inStream != null && inStream.read(new byte[1]) > -1) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

