/*
 * Decompiled with CFR 0.152.
 */
package ifs.docman.lotusnotes.ui;

import ifs.docman.lotusnotes.Activator;
import ifs.docman.lotusnotes.enumerations.EmailSaveOptions;
import ifs.docman.lotusnotes.localization.TextTranslationCache;
import ifs.docman.lotusnotes.localization.TextTranslator;
import ifs.docman.lotusnotes.localization.TranslationLocator;
import ifs.docman.lotusnotes.misc.SWTResourceManager;
import ifs.docman.lotusnotes.model.RegistryObjectModel;
import ifs.docman.lotusnotes.persistance.UserSettingsManager;
import ifs.docman.lotusnotes.ui.Error;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SettingsDialog
extends Dialog {
    RegistryObjectModel registrySettings;
    protected Object result;
    protected Shell shellDocmanSettingsDialog;
    private Image dialogIcon;
    private Image panelImage;
    private Button btnOk;
    private Button btnCancel;
    private Button btnManageLanguageFiles;
    private Button btnLocalCheckoutPathBrowse;
    private Button btnNetworkShareBrowse;
    private Composite panelIFS;
    private Label lblIFSLogo;
    private Combo cmbLanguage;
    private Composite panelGeneral;
    private Label lblGeneral;
    private Composite panelIfsEnterpriseExplorer;
    private Group grpIfsEnterpriseExplorer;
    private Label lblIfsEnterpriseExplorer;
    private Composite panelSaveOptions;
    private Label lblSaveOptions;
    private Label lblLanguage;
    private Label lblDocumentationBaseUrl;
    private Label lblLocalCheckoutPath;
    private Label lblSelectHowDo;
    private Group grpSaveOptionsFor;
    private Label lblSaveOptionsFor;
    private Button rbbtnFromUrl;
    private Button rbbtnFromNetworkShare;
    private Button rbbtnAskMeEvery;
    private Button rbbtnCompleteEmail;
    private Button rbbtnAttachmentsOnly;
    private Button rbbtnEmailOnly;
    private Text tfDocumentationBaseUrl;
    private Text tfLocalCheckoutPath;
    private Text tfFromUrl;
    private Text tfNetworkShare;

    public SettingsDialog(Shell parent) {
        super(parent, 0);
    }

    public SettingsDialog(Shell parent, int style) {
        super(parent, style);
        this.setText(TextTranslator.translate("SettingDialog.SWT.Dialog:SWT Dialog"));
    }

    public Object open() {
        this.loadImages();
        this.createContents();
        this.calculateDialogSize();
        this.addListners();
        try {
            this.registrySettings = UserSettingsManager.loadFromRegistry();
            if (this.registrySettings.DocumentationBaseUrl != null && !"".equals(this.registrySettings.DocumentationBaseUrl)) {
                this.tfDocumentationBaseUrl.setText(this.registrySettings.DocumentationBaseUrl);
            }
            this.cmbLanguage.setItems(TextTranslationCache.getsupportedLanValues());
            String currentLanguage = this.registrySettings.Language;
            this.cmbLanguage.select(TextTranslationCache.getLanguageKeyIndex(currentLanguage));
            if (this.registrySettings.LocalCheckoutPath != null && !"".equals(this.registrySettings.LocalCheckoutPath)) {
                this.tfLocalCheckoutPath.setText(this.registrySettings.LocalCheckoutPath);
            }
            if (this.registrySettings.IeeUrl != null && !"".equals(this.registrySettings.IeeUrl)) {
                this.tfFromUrl.setText(this.registrySettings.IeeUrl);
            }
            if (this.registrySettings.IeePath != null && !"".equals(this.registrySettings.IeePath)) {
                this.tfNetworkShare.setText(this.registrySettings.IeePath);
            }
            this.tfFromUrl.setEnabled(this.registrySettings.IsClickOnceDeployed);
            this.tfNetworkShare.setEnabled(!this.registrySettings.IsClickOnceDeployed);
            this.btnNetworkShareBrowse.setEnabled(!this.registrySettings.IsClickOnceDeployed);
            this.rbbtnFromUrl.setSelection(this.registrySettings.IsClickOnceDeployed);
            this.rbbtnFromNetworkShare.setSelection(!this.registrySettings.IsClickOnceDeployed);
            switch (EmailSaveOptions.valueOf(this.registrySettings.EmailSaveOptions)) {
                case AskMeEveryTime: {
                    this.rbbtnAskMeEvery.setSelection(true);
                    break;
                }
                case AttachmentsOnly: {
                    this.rbbtnAttachmentsOnly.setSelection(true);
                    break;
                }
                case CompleteEmail: {
                    this.rbbtnCompleteEmail.setSelection(true);
                    break;
                }
                case EmailOnly: {
                    this.rbbtnEmailOnly.setSelection(true);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.shellDocmanSettingsDialog.open();
        this.shellDocmanSettingsDialog.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shellDocmanSettingsDialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shellDocmanSettingsDialog = new Shell(this.getParent(), 67680);
        this.shellDocmanSettingsDialog.setImage(this.dialogIcon);
        this.shellDocmanSettingsDialog.setBackground(SWTResourceManager.getColor(1));
        this.shellDocmanSettingsDialog.setSize(487, 515);
        this.shellDocmanSettingsDialog.setText(TextTranslator.translate("SettingDialog.Settings: Settings - Lotus Notes Widget for IFS Document Management"));
        this.panelIFS = new Composite((Composite)this.shellDocmanSettingsDialog, 0);
        this.panelIFS.setBackground(SWTResourceManager.getColor(12));
        this.panelIFS.setBounds(0, 0, 46, 487);
        this.lblIFSLogo = new Label(this.panelIFS, 0);
        this.lblIFSLogo.setImage(this.panelImage);
        this.lblIFSLogo.setBounds(2, 2, 42, 42);
        this.panelGeneral = new Composite((Composite)this.shellDocmanSettingsDialog, 0);
        this.panelGeneral.setBounds(52, 10, 421, 29);
        this.lblGeneral = new Label(this.panelGeneral, 0);
        this.lblGeneral.setFont(SWTResourceManager.getFont("MS Sans Serif", 10, 1));
        this.lblGeneral.setBounds(10, 7, 404, 15);
        this.lblGeneral.setText(TextTranslator.translate("SettingDialog.General: General"));
        this.panelIfsEnterpriseExplorer = new Composite((Composite)this.shellDocmanSettingsDialog, 0);
        this.panelIfsEnterpriseExplorer.setBounds(52, 136, 421, 29);
        this.lblIfsEnterpriseExplorer = new Label(this.panelIfsEnterpriseExplorer, 0);
        this.lblIfsEnterpriseExplorer.setFont(SWTResourceManager.getFont("MS Sans Serif", 10, 1));
        this.lblIfsEnterpriseExplorer.setText(TextTranslator.translate("SettingDialog.IFS.Enterprise: IFS Enterprise Explorer"));
        this.lblIfsEnterpriseExplorer.setBounds(10, 7, 406, 15);
        this.panelSaveOptions = new Composite((Composite)this.shellDocmanSettingsDialog, 0);
        this.panelSaveOptions.setBounds(52, 279, 421, 29);
        this.lblSaveOptions = new Label(this.panelSaveOptions, 0);
        this.lblSaveOptions.setText(TextTranslator.translate("SettingDialog.Save.Options: Save Options"));
        this.lblSaveOptions.setFont(SWTResourceManager.getFont("MS Sans Serif", 10, 1));
        this.lblSaveOptions.setBounds(10, 7, 404, 15);
        this.lblLanguage = new Label((Composite)this.shellDocmanSettingsDialog, 0);
        this.lblLanguage.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.lblLanguage.setBackground(SWTResourceManager.getColor(1));
        this.lblLanguage.setBounds(52, 48, 131, 15);
        this.lblLanguage.setText(TextTranslator.translate("SettingDialog.Language: Language"));
        this.cmbLanguage = new Combo((Composite)this.shellDocmanSettingsDialog, 0);
        this.cmbLanguage.setBounds(189, 44, 113, 23);
        this.btnManageLanguageFiles = new Button((Composite)this.shellDocmanSettingsDialog, 0);
        this.btnManageLanguageFiles.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.btnManageLanguageFiles.setBounds(308, 43, 165, 25);
        this.btnManageLanguageFiles.setText(TextTranslator.translate("SettingDialog.Manage.Language: Manage Language Files..."));
        this.lblDocumentationBaseUrl = new Label((Composite)this.shellDocmanSettingsDialog, 0);
        this.lblDocumentationBaseUrl.setText(TextTranslator.translate("SettingDialog.Documentation.Base: Documentation Base URL"));
        this.lblDocumentationBaseUrl.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.lblDocumentationBaseUrl.setBackground(SWTResourceManager.getColor(1));
        this.lblDocumentationBaseUrl.setBounds(52, 76, 128, 15);
        this.lblLocalCheckoutPath = new Label((Composite)this.shellDocmanSettingsDialog, 0);
        this.lblLocalCheckoutPath.setText(TextTranslator.translate("SettingDialog.Local.Checkout: Local Checkout Path"));
        this.lblLocalCheckoutPath.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.lblLocalCheckoutPath.setBackground(SWTResourceManager.getColor(1));
        this.lblLocalCheckoutPath.setBounds(52, 103, 131, 15);
        this.tfDocumentationBaseUrl = new Text((Composite)this.shellDocmanSettingsDialog, 2048);
        this.tfDocumentationBaseUrl.setBounds(189, 73, 284, 21);
        this.tfDocumentationBaseUrl.setText("http://<server>:<port>/ifsdoc/");
        this.tfLocalCheckoutPath = new Text((Composite)this.shellDocmanSettingsDialog, 2048);
        this.tfLocalCheckoutPath.setBounds(189, 100, 194, 21);
        this.tfLocalCheckoutPath.setText("<drive>:\\<root_folder>\\<folder>");
        this.btnLocalCheckoutPathBrowse = new Button((Composite)this.shellDocmanSettingsDialog, 0);
        this.btnLocalCheckoutPathBrowse.setText(TextTranslator.translate("SettingDialog.Browse: Browse..."));
        this.btnLocalCheckoutPathBrowse.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.btnLocalCheckoutPathBrowse.setBounds(389, 98, 84, 25);
        this.grpIfsEnterpriseExplorer = new Group((Composite)this.shellDocmanSettingsDialog, 0);
        this.grpIfsEnterpriseExplorer.setBackground(SWTResourceManager.getColor(1));
        this.grpIfsEnterpriseExplorer.setBounds(52, 168, 421, 105);
        this.rbbtnFromUrl = new Button((Composite)this.grpIfsEnterpriseExplorer, 16);
        this.rbbtnFromUrl.setBounds(10, 43, 122, 16);
        this.rbbtnFromUrl.setText(TextTranslator.translate("SettingDialog.From.URL: From URL"));
        this.rbbtnFromUrl.setBackground(SWTResourceManager.getColor(1));
        this.rbbtnFromUrl.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.rbbtnFromUrl.setSelection(true);
        this.rbbtnFromNetworkShare = new Button((Composite)this.grpIfsEnterpriseExplorer, 16);
        this.rbbtnFromNetworkShare.setBounds(10, 74, 133, 16);
        this.rbbtnFromNetworkShare.setText(TextTranslator.translate("SettingDialog.From.Path: From Path"));
        this.rbbtnFromNetworkShare.setBackground(SWTResourceManager.getColor(1));
        this.rbbtnFromNetworkShare.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.rbbtnFromNetworkShare.setSelection(false);
        this.lblSelectHowDo = new Label((Composite)this.grpIfsEnterpriseExplorer, 0);
        this.lblSelectHowDo.setBounds(10, 10, 406, 15);
        this.lblSelectHowDo.setText(TextTranslator.translate("SettingDialog.Select.how: Select how do you want to open IFS Enterprise Explorer"));
        this.lblSelectHowDo.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.lblSelectHowDo.setBackground(SWTResourceManager.getColor(1));
        this.btnNetworkShareBrowse = new Button((Composite)this.grpIfsEnterpriseExplorer, 0);
        this.btnNetworkShareBrowse.setBounds(332, 70, 84, 25);
        this.btnNetworkShareBrowse.setText(TextTranslator.translate("SettingDialog.Browse: Browse..."));
        this.btnNetworkShareBrowse.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.tfNetworkShare = new Text((Composite)this.grpIfsEnterpriseExplorer, 2048);
        this.tfNetworkShare.setBounds(144, 72, 184, 21);
        this.tfNetworkShare.setText("<drive>:\\<root_folder>\\<folder>\\Ifs.Fnd.Explorer.exe");
        this.tfFromUrl = new Text((Composite)this.grpIfsEnterpriseExplorer, 2048);
        this.tfFromUrl.setBounds(144, 41, 272, 21);
        this.tfFromUrl.setText("http://<server>:<port>");
        this.grpSaveOptionsFor = new Group((Composite)this.shellDocmanSettingsDialog, 0);
        this.grpSaveOptionsFor.setBackground(SWTResourceManager.getColor(1));
        this.grpSaveOptionsFor.setBounds(52, 309, 421, 140);
        this.lblSaveOptionsFor = new Label((Composite)this.grpSaveOptionsFor, 0);
        this.lblSaveOptionsFor.setBounds(10, 10, 406, 15);
        this.lblSaveOptionsFor.setText(TextTranslator.translate("SettingDialog.Save.options: Save options for E-Mails with Attachments"));
        this.lblSaveOptionsFor.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.lblSaveOptionsFor.setBackground(SWTResourceManager.getColor(1));
        this.rbbtnAskMeEvery = new Button((Composite)this.grpSaveOptionsFor, 16);
        this.rbbtnAskMeEvery.setBounds(10, 31, 406, 16);
        this.rbbtnAskMeEvery.setText(TextTranslator.translate("SettingDialog.Display.save: Display the save options dialog"));
        this.rbbtnAskMeEvery.setBackground(SWTResourceManager.getColor(1));
        this.rbbtnAskMeEvery.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.rbbtnAskMeEvery.setSelection(false);
        this.rbbtnCompleteEmail = new Button((Composite)this.grpSaveOptionsFor, 16);
        this.rbbtnCompleteEmail.setBounds(10, 53, 406, 16);
        this.rbbtnCompleteEmail.setText(TextTranslator.translate("SettingDialog.Save.mail.with.attachments: Save the e-mail with attachments"));
        this.rbbtnCompleteEmail.setBackground(SWTResourceManager.getColor(1));
        this.rbbtnCompleteEmail.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.rbbtnAskMeEvery.setSelection(true);
        this.rbbtnAttachmentsOnly = new Button((Composite)this.grpSaveOptionsFor, 16);
        this.rbbtnAttachmentsOnly.setBounds(10, 75, 406, 16);
        this.rbbtnAttachmentsOnly.setText(TextTranslator.translate("SettingDialog.Only.attachments: Only save the attachments"));
        this.rbbtnAttachmentsOnly.setBackground(SWTResourceManager.getColor(1));
        this.rbbtnAttachmentsOnly.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.rbbtnAskMeEvery.setSelection(false);
        this.rbbtnEmailOnly = new Button((Composite)this.grpSaveOptionsFor, 16);
        this.rbbtnEmailOnly.setBounds(10, 97, 406, 16);
        this.rbbtnEmailOnly.setText(TextTranslator.translate("SettingDialog.Save.email: Save the e-mail without attachments"));
        this.rbbtnEmailOnly.setBackground(SWTResourceManager.getColor(1));
        this.rbbtnEmailOnly.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.rbbtnEmailOnly.setVisible(false);
        this.rbbtnAskMeEvery.setSelection(false);
        this.btnOk = new Button((Composite)this.shellDocmanSettingsDialog, 0);
        this.btnOk.setText(TextTranslator.translate("SettingDialog.OK: OK"));
        this.btnOk.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.btnOk.setBounds(299, 455, 84, 25);
        this.btnCancel = new Button((Composite)this.shellDocmanSettingsDialog, 0);
        this.btnCancel.setText(TextTranslator.translate("SettingDialog.Cancel: Cancel"));
        this.btnCancel.setFont(SWTResourceManager.getFont("MS Sans Serif", 8, 0));
        this.btnCancel.setBounds(389, 455, 84, 25);
    }

    private void calculateDialogSize() {
    }

    private void loadImages() {
        this.dialogIcon = Activator.getImageDescriptor("icons/16x16_purple-doc.ico").createImage();
        this.panelImage = Activator.getImageDescriptor("icons/ifs-icon-with-frame.png").createImage();
    }

    private void addListners() {
        Listener manageLngFilesButtonListner = new Listener(){

            public void handleEvent(Event event) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.open(TranslationLocator.getLocalizationPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        Listener localCheckoutPathBrowseButtonListner = new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog locaCheckoutPathDialog = new DirectoryDialog(SettingsDialog.this.shellDocmanSettingsDialog);
                locaCheckoutPathDialog.setFilterPath(SettingsDialog.this.tfLocalCheckoutPath.getText());
                String selectedLocalCheckoutPath = locaCheckoutPathDialog.open();
                if (selectedLocalCheckoutPath != null) {
                    SettingsDialog.this.tfLocalCheckoutPath.setText(selectedLocalCheckoutPath);
                }
            }
        };
        Listener networkShareBrowseButtonListner = new Listener(){

            public void handleEvent(Event event) {
                FileDialog networkSharepathDialog = new FileDialog(SettingsDialog.this.shellDocmanSettingsDialog);
                networkSharepathDialog.setFilterPath(new File(SettingsDialog.this.tfNetworkShare.getText()).getParent());
                String selectedNetworkSharePath = networkSharepathDialog.open();
                if (selectedNetworkSharePath != null) {
                    SettingsDialog.this.tfNetworkShare.setText(selectedNetworkSharePath);
                }
            }
        };
        Listener okButtonListner = new Listener(){

            public void handleEvent(Event event) {
                SettingsDialog.this.registrySettings.DocumentationBaseUrl = SettingsDialog.this.tfDocumentationBaseUrl.getText();
                SettingsDialog.this.registrySettings.LocalCheckoutPath = SettingsDialog.this.tfLocalCheckoutPath.getText();
                SettingsDialog.this.registrySettings.IsClickOnceDeployed = SettingsDialog.this.rbbtnFromUrl.getSelection();
                if (SettingsDialog.this.registrySettings.IsClickOnceDeployed) {
                    SettingsDialog.this.registrySettings.IeeUrl = SettingsDialog.this.tfFromUrl.getText();
                } else {
                    SettingsDialog.this.registrySettings.IeePath = SettingsDialog.this.tfNetworkShare.getText();
                }
                if (SettingsDialog.this.rbbtnAskMeEvery.getSelection()) {
                    SettingsDialog.this.registrySettings.EmailSaveOptions = EmailSaveOptions.AskMeEveryTime.toString();
                } else if (SettingsDialog.this.rbbtnAttachmentsOnly.getSelection()) {
                    SettingsDialog.this.registrySettings.EmailSaveOptions = EmailSaveOptions.AttachmentsOnly.toString();
                } else if (SettingsDialog.this.rbbtnCompleteEmail.getSelection()) {
                    SettingsDialog.this.registrySettings.EmailSaveOptions = EmailSaveOptions.CompleteEmail.toString();
                } else if (SettingsDialog.this.rbbtnEmailOnly.getSelection()) {
                    SettingsDialog.this.registrySettings.EmailSaveOptions = EmailSaveOptions.EmailOnly.toString();
                }
                String selectedLangue = TextTranslationCache.getSupportedLanKeys()[SettingsDialog.this.cmbLanguage.getSelectionIndex()];
                if (selectedLangue != null && !selectedLangue.equals(SettingsDialog.this.registrySettings.Language) && TextTranslationCache.changeLanguage(selectedLangue)) {
                    SettingsDialog.this.registrySettings.Language = selectedLangue;
                }
                try {
                    this.validateUserSettings(SettingsDialog.this.registrySettings);
                    URL ieeUrl = new URL(SettingsDialog.this.registrySettings.IeeUrl);
                    SettingsDialog.this.registrySettings.IeeUrl = String.valueOf(ieeUrl.getProtocol()) + "://" + ieeUrl.getAuthority();
                    UserSettingsManager.storeInRegistry(SettingsDialog.this.registrySettings);
                    Error.setDefalultShell();
                    SettingsDialog.this.shellDocmanSettingsDialog.close();
                }
                catch (Exception ex) {
                    Error.showError(ex.getMessage());
                }
            }

            private void validateUserSettings(RegistryObjectModel registrySettings) throws Exception {
                File ieeFile;
                StringBuilder errorMessageToUser = new StringBuilder(TextTranslator.translate("SettingDialog.Err.FieldsInvalid: The following fields are invalid: "));
                Vector<String> errorMessages = new Vector<String>();
                if (registrySettings.Language == null || registrySettings.Language.isEmpty()) {
                    errorMessages.add(TextTranslator.translate("SettingDialog.Err.LanguageCannotbeEmpty: Language cannot be empty."));
                }
                if (registrySettings.DocumentationBaseUrl == null || registrySettings.DocumentationBaseUrl.isEmpty()) {
                    errorMessages.add(TextTranslator.translate("SettingDialog.Err.DocUrlCannotEmpty: The documentation base URL cannot be empty."));
                }
                if (registrySettings.LocalCheckoutPath == null || registrySettings.LocalCheckoutPath.isEmpty()) {
                    errorMessages.add(TextTranslator.translate("SettingDialog.Err.CPathCannotEmpty: The local check-out path cannot be empty."));
                } else {
                    ieeFile = new File(registrySettings.LocalCheckoutPath);
                    if (!ieeFile.isDirectory() || !ieeFile.exists()) {
                        errorMessages.add(TextTranslator.translate("SettingDialog.Err.CPathNotExist: The local check-out path doesn't exist."));
                    }
                }
                if (registrySettings.IsClickOnceDeployed) {
                    if (registrySettings.IeeUrl == null || registrySettings.IeeUrl.isEmpty()) {
                        errorMessages.add(TextTranslator.translate("SettingDialog.Err.IEEURLCannotEmpty: Enterprise Explorer URL cannot be empty."));
                    } else if (!this.isValidURL(registrySettings.IeeUrl)) {
                        errorMessages.add(TextTranslator.translate("SettingDialog.Err.IEEURLNotValid: Enterprise Explorer URL format is not valid."));
                    }
                } else if (registrySettings.IeePath == null || registrySettings.IeePath.isEmpty()) {
                    errorMessages.add(TextTranslator.translate("SettingDialog.Err.IEEPathCannotEmpty: Enterprise Explorer Path cannot be empty."));
                } else {
                    ieeFile = new File(registrySettings.IeePath);
                    if (ieeFile.isDirectory() || !ieeFile.exists()) {
                        errorMessages.add(TextTranslator.translate("SettingDialog.Err.IEEPathNotExist: Enterprise Explorer Path doesn't exist."));
                    }
                }
                for (String errorMessage : errorMessages) {
                    errorMessageToUser.append("\n - " + errorMessage);
                }
                if (errorMessages.size() > 0) {
                    throw new Exception(errorMessageToUser.toString());
                }
            }

            private boolean isValidURL(String urlPath) {
                try {
                    URL ieeURL = new URL(SettingsDialog.this.registrySettings.IeeUrl);
                    return ieeURL.getProtocol().equalsIgnoreCase("http") || ieeURL.getProtocol().equalsIgnoreCase("https");
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
        Listener cancelButtonListner = new Listener(){

            public void handleEvent(Event event) {
                SettingsDialog.this.shellDocmanSettingsDialog.close();
            }
        };
        SelectionListener saveOptionsListner = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                SettingsDialog.this.tfNetworkShare.setEnabled(!SettingsDialog.this.rbbtnFromUrl.getSelection());
                SettingsDialog.this.tfFromUrl.setEnabled(SettingsDialog.this.rbbtnFromUrl.getSelection());
                SettingsDialog.this.btnNetworkShareBrowse.setEnabled(!SettingsDialog.this.rbbtnFromUrl.getSelection());
            }
        };
        this.btnOk.addListener(13, okButtonListner);
        this.btnCancel.addListener(13, cancelButtonListner);
        this.btnManageLanguageFiles.addListener(13, manageLngFilesButtonListner);
        this.btnLocalCheckoutPathBrowse.addListener(13, localCheckoutPathBrowseButtonListner);
        this.btnNetworkShareBrowse.addListener(13, networkShareBrowseButtonListner);
        this.rbbtnFromNetworkShare.addSelectionListener(saveOptionsListner);
    }
}

